--[[---------------------------------------------------------------------------
	Chocolatier Two Main Menu
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Save the game every entry to main menu
if gSim then gSim:SaveGame() end

-- Main Menu fonts in varying sizes
local h1 = kForty
local h2 = kThirty
local h3 = kTwentyTwo
local h4 = kSixteen
local f1 = { standardFont[1], h1, standardYellowFont[3] }
local f2 = { standardFont[1], h2, standardYellowFont[3] }
local f3 = { standardFont[1], h3, standardYellowFont[3] }
local f4 = { standardFont[1], h4, standardYellowFont[3] }

--local fW = { standardFont[1], kEighteen, DialogColor }
local fW = standardYellowFont

-------------------------------------------------------------------------------

local storyButton = { "control/mm_empire_up", "control/mm_empire_down", "control/mm_empire_over" }
local freeButton = { "control/mm_free_up", "control/mm_free_down", "control/mm_free_over" }
local changeButton = { "control/mm_change_up", "control/mm_change_down", "control/mm_change_over" }
local helpButton = { "control/mm_help_up", "control/mm_help_down", "control/mm_help_over" }
local optionsButton = { "control/mm_opt_up", "control/mm_opt_down", "control/mm_opt_over" }
local scoresButton = { "control/mm_scores_up", "control/mm_scores_down", "control/mm_scores_over" }
local quitButton = { "control/mm_back_up", "control/mm_back_down", "control/mm_back_over" }
local moreButton = { "control/mm_moregames_up", "control/mm_moregames_down", "control/mm_moregames_over" }

local function OutlineLabel(k)
	return "<outline color='000000' size=2>"..GetString(k)
end

local function OutlineDisableLabel(k)
	return "<outline color='000000' size=2><font color='888888'>"..GetString(k)
end

-------------------------------------------------------------------------------

local function Update()
	if GetNumUsers() == 0 then
		SetLabel("choose_label", OutlineDisableLabel("choose_player"))
		SetLabel("free_label", OutlineDisableLabel("free_mode"))
		EnableWindow("disabled_buttons", true)
		
		EnableWindow("free_mode", false)
		EnableWindow("free_fadeout", false)
		EnableWindow("choose_player", false)
		EnableWindow("choose_fadeout", false)
	else
		SetLabel("welcome", "<outline color='00000000' size=2>"..GetString("welcome_back", GetUserName(GetCurrentUser())))
		SetLabel("choose_label", OutlineLabel("choose_player"))
		SetLabel("free_label", OutlineLabel("free_mode"))
		EnableWindow("disabled_buttons", false)
		EnableWindow("choose_player", true)
		EnableWindow("choose_fadeout", true)
		EnableWindow("free_mode", true)
		EnableWindow("free_fadeout", true)
	end
	
	if not bsgCheckConfig("xsell") then
		EnableWindow("xsell", false)
		EnableWindow("xsell_label", false)
		EnableWindow("xsell_fadeout", false)
	end
end

local function StoryMode()
	local ok = false
	if GetNumUsers() == 0 then
		local name = DoModal("ui/entername.lua")
		if name and name ~= "" then
			SetCurrentGameMode(0)
			CreateNewUser(name)
			ok = Simulator:LoadGame()
		end
	else
		ok = true
		SetCurrentGameMode(0)
		if (not gSim) or (gSim.mode ~= "story") then
			ok = Simulator:LoadGame()
		end
	end
	
	if gSim and ok then
		local q = LQuest:ByName("tutor00b")
		if q and not q.complete and not gSim.quest then
			-- Prepare to fade...
			EnableWindow("fade_buttons", true)
			EnableWindow("buttons", false)
			DoIntro()
		elseif gSim.rank < 1 then
			SwapToModal("ui/portview.lua")
		else
			SwapToModal("ui/map.lua")
		end
	end
end

function MainMenuFinishIntro()
	SwapToModal("ui/portview.lua")
	SetLedgerContents("messages")
	StopPulsing()
	local b = LBuilding:ByName("sf_bchq")
	if b then b:OnActivate() end
end

local function FreeMode()
	local ok = false
	if GetNumUsers() > 0 then
		SetCurrentGameMode(1)
		if (not gSim) or (gSim.mode ~= "free") then
			ok = Simulator:LoadGame()
		elseif gSim then
			-- simulator already loaded and set to free play mode
			ok = true
		end
	end

	if gSim and ok then
		SwapToModal("ui/map.lua")
	else
		DisplayDialog { "ui/okdialog.lua", body="no_freeplay" }
	end
end

local function Options()
	DoModal("ui/options.lua")
	Update()
end

local function HighScores()
	if bsgCheckConfig("local") then DoModal("ui/hiscore_local.lua")
	else DoModal("ui/hiscore.lua")
	end
	Update()
end

local function ChangePlayer()
	DoModal("ui/chooseplayer.lua")
	Update()
end

local function Help()
	DisplayDialog { "ui/help1.lua" }
end

-------------------------------------------------------------------------------

function QuitGame()
	local r = DisplayDialog { "ui/yndialog.lua", body="confirm_quit" }
	if r == "yes" then
		if gSim then gSim:FirstPeekProgress() end
		PostMessage(CreateNamedMessage(kQuitNow, "Quit"))
	end
end

-------------------------------------------------------------------------------

MakeDialog
{
	name="mainmenu", fit=true,
	bsgScreen
	{
		Bitmap
		{
			x=kCenter,y=kCenter,w=ui.screenWidth,h=ui.screenHeight,
			image="image/mainmenu",
			
			MainMenu { x=0,y=0,w=ui.screenWidth,h=ui.screenHeight,
				Button { x=0,y=0,w=ui.screenWidth,h=ui.screenHeight, graphics={}, name="intro_button",
					default=true,
					command = MainMenuFinishIntro,
					Text { x=100,y=0,w=600,h=500, label="intro_scroll", name="intro_text",
						font=f2, flags=kVAlignCenter + kHAlignLeft },
				},
			},
						
			Bitmap { x=0,y=0,image="image/splash_title", },
			
			Window { x=0,y=0,w=ui.screenWidth,h=ui.screenHeight, name="disabled_buttons",
				Bitmap { x=117-45,y=417-45, image="control/mm_change_disabled", name="choose_disabled" },
				Bitmap { x=230-45,y=455-45, image="control/mm_free_disabled", name="free_disabled" },
			},
			
			Window { x=0,y=0,w=ui.screenWidth,h=ui.screenHeight, name="fade_buttons",
				Bitmap { x=400-75,y=315-75+30, scale=1.0, image=storyButton[3] },
				Bitmap { x=117-45,y=417-45, image=changeButton[1], name="choose_fadeout" },
				Bitmap { x=230-45,y=455-45, image=freeButton[1], name="free_fadeout" },
				Bitmap { x=457-45,y=475-45, image=helpButton[1] },
				Bitmap { x=343-45,y=475-45, image=optionsButton[1] },
				Bitmap { x=570-45,y=455-45, image=scoresButton[1] },
				Bitmap { x=683-45,y=417-45, image=quitButton[1] },
				Bitmap { x=80-45*.8,y=520-45*.8, image=moreButton[1], name="xsell_fadeout" },
			},
			
			Window { x=0,y=0,w=ui.screenWidth,h=ui.screenHeight, name="buttons",
				AppendStyle { rolloversound="sfx/main_rollover.ogg" },
				Button { x=400-75,y=315-75+30, scale=1.0, graphics=storyButton, command=StoryMode },
				Button { x=117-45,y=417-45, graphics=changeButton, name="choose_player", command=ChangePlayer},
				Button { x=230-45,y=455-45, graphics=freeButton, name="free_mode", command=FreeMode },
				Button { x=457-45,y=475-45, graphics=helpButton, command=Help},
				Button { x=343-45,y=475-45, graphics=optionsButton, command=Options},
				Button { x=570-45,y=455-45, graphics=scoresButton, command=HighScores},
				Button { x=683-45,y=417-45, graphics=quitButton, command=QuitGame},
				Button { x=80-45*.8,y=520-45*.8, graphics=moreButton, name="xsell", command=function() DoModal("xsell/xsell.lua") end },
			},
			
			Window { x=0,y=0,w=ui.screenWidth,h=ui.screenHeight, name="fade_text",
				Text { x=400-100,y=320+32+30, w=200,h=kMax, label="#"..OutlineLabel("story_mode"), flags=kVAlignTop+kHAlignCenter, font=f1 },
				Text { x=117-100,y=417+32, w=200,h=kMax, label="#"..OutlineDisableLabel("choose_player"), name="choose_label", flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=230-100,y=455+32, w=200,h=kMax, label="#"..OutlineDisableLabel("free_mode"), name="free_label", flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=457-100,y=475+32, w=200,h=kMax, label="#"..OutlineLabel("help"), flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=343-100,y=475+32, w=200,h=kMax, label="#"..OutlineLabel("options"), flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=570-100,y=455+32, w=200,h=kMax, label="#"..OutlineLabel("highscores"), flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=683-100,y=417+32, w=200,h=kMax, label="#"..OutlineLabel("quit"), flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=0,y=550+32*.8, w=160,h=kMax, label="#"..OutlineLabel("moregames"), name="xsell_label", flags=kVAlignTop+kHAlignCenter, font=f3 },
				Text { x=kCenter,y=kMax-h4-20, w=kMax,h=20, name="welcome", label="", font=fW },
				Text { x=0,y=kMax-h4,w=kMax,h=h4, label="copyright", font=f4, flags=kHAlignCenter+kVAlignBottom },
			},
		},
	},
}

Update()
SetMusicState("normal", "music/gameplay4.ogg")
SetAmbient("")
bsgTriggerOffer()		-- TOGETHER
StopProductionAnim()	-- Just in case
ResetColorMap()			-- Prepare to switch players or modes

EnableWindow("fade_buttons", false)
EnableWindow("intro_button", false)
